local c;
local player = Var "Player";
local ShowComboAt = THEME:GetMetric("Combo", "ShowComboAt");
local ShowMissComboAt = THEME:GetMetric("Combo", "ShowMissComboAt");
local Pulse = THEME:GetMetric("Combo", "LabelPulseCommand");

local t = Def.ActorFrame {
		LoadFont("RX") .. {
		Text="COMBO";
			Name="ComboLabel";
			InitCommand=cmd(visible,false;y,-16);
		};
};

t.InitCommand = function(self)
	c = self:GetChildren();
	c.ComboLabel = c.NumberFrame:GetChild("ComboLabel");
	c.ComboLabel:visible(false);
end;

t.OnCommand = function(self)
	-- Set the frame around the number as the Combo actor, so it's
	-- moved by ComboTransformCommand.  Don't set the number itself,
	-- since we want to set an explicit zoom on it, and ComboTransformCommand
	-- will override the whole TweenState.
	local player = self:GetParent();
	--player:SetActorWithComboPosition( c.NumberFrame );
end;

t.ComboCommand=function(self, param)
	local iCombo = param.Misses or param.Combo;
	local iShowComboAt = (param.Misses and param.Misses > 0) and ShowMissComboAt or ShowComboAt;
	
	c.ComboLabel:stoptweening();
	c.ComboLabel:diffuse( color("#FFFFFF") );
	
	if param.Misses then
		c.ComboLabel:diffuse( color("#FF2020") );
	end
	
		--c.Number:diffuse( color("#FF2020") );
	
	
	if GetUserPref("UserPrefJudgmentType") == "Normal" or GetUserPref("UserPrefJudgmentType") == "Deviation" then
		Pulse( c.ComboLabel, param );
	end
	
	if GetUserPref("UserPrefJudgmentType") == "NX" then
		(cmd(stoptweening;diffusealpha,1;zoomx,0.65;zoomy,0.75;linear,0.075;zoomx,0.465;zoomy,0.385;sleep,1;linear,0.2;diffusealpha,0;zoomx,1.05;zoomy,0.5))(c.ComboLabel,param);
	end	

	if GetUserPref("UserPrefJudgmentType") == "Fiesta" then
		(cmd(stoptweening;diffusealpha,1;zoomx,0.65;zoomy,0.75;linear,0.075;zoomx,0.465;zoomy,0.385;sleep,1;linear,0.2;diffusealpha,0;zoomx,1.05;zoomy,0.5))(c.ComboLabel,param);
	end	

	if GetUserPref("UserPrefJudgmentType") == "Pro" then
			local RestZoom = 0.75;
			local CurrentZoom = 0.75
			local DestZoom = 1;
			local PercentToRest = scale( CurrentZoom, RestZoom, DestZoom, 1, 0 );
			local Time = 0.05;
	
		(cmd(stoptweening;linear,Time*PercentToRest;zoom,DestZoom;linear,Time;zoom,RestZoom))(c.ComboLabel,param);
	end
	
	-- Do the above even if we're not going to show the combo, so the
	-- tweening always matches up with the judgement.
	if not iCombo or iCombo < iShowComboAt then
		c.ComboLabel:visible(false);
	else
		c.ComboLabel:visible(true);
	end
end;

return t;
